/* gm_objectives.sma is part of GabenMod
*  Copyright 2005-2006 by BAILOPAN (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#if defined CSDM_COMPILATION
#include <csdm>
#endif
#include <nvault>
#include <cstrike>
#include "gabenmod"

#define MAX_HOSTAGES 32
#define MAX_RESCUEZONES 16
#define MAX_ENTS 1400

/** Objective States */

/* Bomb stuff */
new g_BombPlanter = -1
new g_ObjectiveWinner
/* Hostage stuff */
new g_IsHostage[MAX_ENTS]
new g_HostageEnt[MAX_HOSTAGES]
new Float:g_HostageOrigin[MAX_HOSTAGES][3]
new g_HostageCount
new g_RescuingHostage[33]

new pt_id, pt_body, Float:pt_fVec[3], pt_hid
// Reward
new g_Winners[32]
new g_WinnerCount = 0
new CsTeams:g_WinningTeam
new g_RewardWinner
new g_HealthAwards[33]
// Messages
new g_msgScoreInfo
new gXPVault, gXP[33]
// CVARs
new cXPReward, cPointReward

new g_IsEnabled = 1

public plugin_init()
{
	register_plugin("GM Objectives", GABENMOD_VERSION, "BAILOPAN")
	register_forward(FM_ClientDisconnect, "hook_death") // works
	register_forward(FM_PlayerPostThink, "hook_postthink")
	/* de_ stuff by BAILOPAN */
	register_logevent("bomb_planted", 3, "2=Planted_The_Bomb")
	register_logevent("defuse_done", 3, "2=Defused_The_Bomb")
	register_logevent("bomb_exploded", 6, "3=Target_Bombed")
	register_logevent("target_saved", 6, "3=Target_Saved")
	/* cs_ stuff by Basic-Master */
	register_logevent("all_hostages_rescued", 6, "3=All_Hostages_Rescued")
	register_logevent("hostages_not_rescued", 6, "3=Hostages_Not_Rescued")
	register_logevent("touched_hostage", 3, "2=Touched_A_Hostage")
	register_logevent("hostage_rescued", 3, "2=Rescued_A_Hostage")
	register_event("DeathMsg", "hook_death", "b")
	/* CVARs */
	cXPReward = register_cvar("gm_reward_xp", "5")
	cPointReward = register_cvar("gm_reward_points", "25")
	
	#if !defined CSDM_COMPILATION
	register_event("HLTV", "hook_roundstart", "a", "1=0", "2=0")
	#endif
	
	g_IsEnabled = gm_IsEnabled()
	g_msgScoreInfo = get_user_msgid("ScoreInfo")
	gXPVault = nvault_open("GM Extra Points")
}

public plugin_cfg() {
	// get hostages
	new startent = -1, lastent = 0, setstartent = 0
	while (lastent != startent || setstartent) {
		lastent = engfunc(EngFunc_FindEntityByString, lastent, "classname", "hostage_entity")
		setstartent = 0
		
		if (pev_valid(lastent)) {
			g_IsHostage[lastent] = 1
			
			if (g_HostageCount == MAX_HOSTAGES)
				break
			if (startent == 0) {
				startent = lastent
				setstartent = 1
			}
			
			g_HostageEnt[g_HostageCount] = lastent
			pev(lastent, pev_origin, g_HostageOrigin[g_HostageCount])
			g_HostageCount++
		}
		else
			break
	}
	// and prepare everything ^^
	hook_roundstart()
}

//well aware there is a core function to do this.
//I don't trust it.
GetLogUser(const text[])
{
	new i
	new end = containi(text, "><STEAM_")
	if (end <= 0)
		return 0
		
	new begin = -1
	for (i=end-1; i>=0; i--)
	{
		if (text[i] == '<')
		{
			begin = i
			break
		} else if (!isdigit(text[i])) {
			break
		}
	}
	
	if (begin == -1)
		return 0
		
	static userid_text[24]
	static players[32]
	new len
	
	for (i=begin+1; i<end; i++)
	{
		if (len >= 23)
			break
		userid_text[len++] = text[i]
	}
	userid_text[len] = 0
	
	new userid = str_to_num(userid_text)
	new num, check, pv
	
	get_players(players, num)
	for (new i=0; i<num; i++)
	{
		pv = players[i]
		check = get_user_userid(pv)
		if (check <= 0)
			continue
		if (check == userid)
			return pv
	}
	
	return 0
}

public client_disconnect(id)
{
	if (g_HealthAwards[id])
	{
		g_HealthAwards[id] = 0
	}
}

AddHealth(id, hp)
{
	new Float:oldhp
	
	pev(id, pev_health, oldhp)
	set_user_health(id, oldhp + float(hp))
}

public gm_WeaponsStripped(id)
{
	if (g_IsEnabled && g_HealthAwards[id])
	{
		AddHealth(id, g_HealthAwards[id])
		g_HealthAwards[id] = 0
	}
}

#if defined CSDM_COMPILATION
public csdm_RoundRestart(post)
{
	if (post)
		hook_roundstart()
}
#endif

public hook_roundstart()
{
	if (g_IsEnabled) {
		static players[32], num, i, pl
		new CsTeams:team = CS_TEAM_UNASSIGNED
		if (g_ObjectiveWinner) {
			if (is_user_connected(g_ObjectiveWinner))
				team = cs_get_user_team(g_ObjectiveWinner)
			else
				return
		}
		get_players(players, num)
		
		// Hostages, wtf?!
		if (g_BombPlanter == -1 && g_WinningTeam != CS_TEAM_UNASSIGNED) {
			// Messages
			if (g_WinningTeam == CS_TEAM_CT) {
				client_print(0, print_chat, "[GM] Counter-Terrorists won the round!")
	
				// Points or Karma
				if (g_RewardWinner) {
					new gRewarded[33]
					for(i=0;i<g_WinnerCount;i++) {
						pl = g_Winners[i]
						if (!gRewarded[pl] && is_user_connected(pl) && cs_get_user_team(pl) == CS_TEAM_CT) {
							#if defined KARMA_SUPPORTED
							if (get_forum_flags(pl) >= FORUM_REGISTERED) {
								alter_user_karma(pl, 1)
								client_print(pl, print_chat, "[GM] You've gained 1 karma and %d XP for rescuing a hostage.", get_pcvar_num(cXPReward))
							}
							#else
							gm_AddPoints(pl, get_pcvar_num(cPointReward), 0)
							client_print(pl, print_chat, "[GM] You've gained %d points and %d XP for rescuing a hostage.", get_pcvar_num(cPointReward), get_pcvar_num(cXPReward))
							#endif
							alter_xp(pl, get_pcvar_num(cXPReward))
							gRewarded[pl] = 1
							g_Winners[i] = 0
						}
					}
					// HP
					for (i=0;i<num;i++) {
						pl = players[i]
						if (cs_get_user_team(pl) == team && !gRewarded[pl]) {
							gm_AddPoints(pl, 2, 0)
							g_HealthAwards[pl] = 50
						}
					}
				}
			}
			else {
				client_print(0, print_chat, "[GM] Terrorists won the round!")
				
				// Points or Karma
				if (g_RewardWinner) {
					new gRewarded[33]
					// Karma
					for(i=0;i<g_WinnerCount;i++) {
						pl = g_Winners[i]
						if (!gRewarded[pl] && is_user_connected(pl) && cs_get_user_team(pl) == CS_TEAM_T) {
							#if defined KARMA_SUPPORTED
							if (get_forum_flags(pl) >= FORUM_REGISTERED) {
								alter_user_karma(pl, 1)
								client_print(pl, print_chat, "[GM] You've gained 1 karma and 1 XP for preventing the CTs from rescuing the hostages.")
							}
							#else
							gm_AddPoints(pl, get_pcvar_num(cPointReward), 0)
							client_print(pl, print_chat, "[GM] You've gained %d points and %d XP for preventing the CTs from rescuing the hostages.", get_pcvar_num(cPointReward), get_pcvar_num(cXPReward))
							#endif
							alter_xp(pl, get_pcvar_num(cXPReward))
							gRewarded[pl] = 1
							g_Winners[i] = 0
						}
					}
					// HP
					for (i=0;i<num;i++) {
						pl = players[i]
						if (cs_get_user_team(pl) == team && !gRewarded[pl]) {
							gm_AddPoints(pl, 1, 0)
							g_HealthAwards[pl] = 50
						}
					}
				}
			}
		}
		// Bomb stuff
		else if (g_WinningTeam != CS_TEAM_UNASSIGNED) {
			new id = g_ObjectiveWinner
			if (id && is_user_connected(id)) {
				static name[32]
				
				get_user_name(id, name, 31)
				client_print(0, print_chat, "[GM] %s's team won the round!", name)
			}
			else
				client_print(0, print_chat, "[GM] Counter-Terrorists won the round!")
			
			if (g_RewardWinner) {
				if (id) {
					#if defined KARMA_SUPPORTED
					if (get_forum_flags(id) >= FORUM_REGISTERED)
						alter_user_karma(id, 1)
					gm_AddPoints(id, 6, 0)
					if (!g_BombPlanter)
						client_print(id, print_chat, "[GM] You've got 1 karma and %d XP for defusing the bomb!", get_pcvar_num(cXPReward))
					else
						client_print(id, print_chat, "[GM] You've got 1 karma and %d XP for planting the bomb!", get_pcvar_num(cXPReward))
					#else
					gm_AddPoints(id, get_pcvar_num(cPointReward), 0)
					if (!g_BombPlanter)
						client_print(id, print_chat, "[GM] You've got %d poins and %d XP for defusing the bomb!", get_pcvar_num(cPointReward), get_pcvar_num(cXPReward))
					else
						client_print(id, print_chat, "[GM] You've got %d poins and %d XP for planting the bomb!", get_pcvar_num(cPointReward), get_pcvar_num(cXPReward))
					#endif
					alter_xp(id, get_pcvar_num(cXPReward))
				}
				
				for (i=0; i<num; i++)
				{
					pl = players[i]
					if (cs_get_user_team(pl) == team && pl != id)
					{
						gm_AddPoints(pl, 1, 0)
						g_HealthAwards[pl] = 50
					}
				}
				
				if (id) {
					g_HealthAwards[id] = 50
					new Float:frags
					pev(id, pev_frags, frags)
					frags += 7.0
					set_pev(id, pev_frags, frags)
					g_ObjectiveWinner = 0
					message_begin(MSG_BROADCAST, g_msgScoreInfo)
					write_byte(id)
					write_short(floatround(frags))
					write_short(get_user_deaths(id))
					write_short(0)
					write_short(get_user_team(id))
					message_end()
				}
			}
		}
		else {
			if (get_playersnum() >= 8)
			{
				client_print(0, print_chat, "[GM] No objective winners this round.")
				client_print(0, print_chat, "[GM] Subtracting 2 points and 2 XP from all players.")
				get_players(players, num)
				for (i=0; i<num; i++) {
					if (gm_GetPoints(players[i]) > 2) {
						gm_RemPoints(players[i], 2, 0)
						alter_xp(players[i], -2)
					}
				}
			}
		}
		// hostages get godmode, wtf!
		set_task(0.1, "task_hostage_god")
	}
	// misc
	g_ObjectiveWinner = 0
	g_WinnerCount = 0
	g_RewardWinner = 0
	g_WinningTeam = CS_TEAM_UNASSIGNED
	arrayset(g_RescuingHostage, 0, 33)
}

public task_hostage_god() {
	if (!g_IsEnabled) return
	
	new hostage, Float:health
	for(new i=0;i<g_HostageCount;i++) {
		hostage = g_HostageEnt[i]
		if (pev_valid(hostage)) {
			pev(hostage, pev_health, health)
			if (health != 0.0)
				set_pev(hostage, pev_health, 999999.0)
		}
	}
}

public hook_death() {
	if (!g_IsEnabled) return
	
	new attacker = read_data(1)
	new victim = read_data(2)
	if (gm_IsValidPlayer(attacker) && gm_IsValidPlayer(victim) && cs_get_user_team(attacker) == CS_TEAM_T) {
		if (cs_get_user_team(victim) == CS_TEAM_CT && g_RescuingHostage[victim]) {
			client_print(attacker, print_chat, "[GM] You've killed a CT rescuing a hostage. You can now ^"use^" hostages to teleport them back to their previous position.")
			g_RescuingHostage[victim] = 0
		}
	}
}

// hooks for de_ maps
public bomb_planted()
{
	new userdata[48]
	read_logargv(0, userdata, 48)
	new id = GetLogUser(userdata)
	if (!id)
		return
	
	if (g_IsEnabled && g_BombPlanter == 0) {
		g_RewardWinner = 0
		
		new players[32], count, player
		get_players(players, count)
		for(new i=0;i<count;i++) {
			player = players[i]
			if (gm_IsValidPlayer(player) && cs_get_user_team(player) == CS_TEAM_CT) {
				client_print(player, print_chat, "[GM] You were given a defuse kit, go and try to defuse the bomb!")
				cs_set_user_defuse(player, 1)
				g_RewardWinner = 1
			}
		}
		
		g_BombPlanter = id
	}
}

public bomb_exploded()
{
	if (g_BombPlanter)
	{
		g_ObjectiveWinner = g_BombPlanter
		g_BombPlanter = 0
		g_WinningTeam = CS_TEAM_T
	}
}

public defuse_done()
{
	new userdata[48]
	read_logargv(0, userdata, 48)
	
	new id = GetLogUser(userdata)
	if (!id)
		return
	
	g_ObjectiveWinner = id
	g_RewardWinner = (get_playersnum() >= 4)
	g_BombPlanter = 0
	g_WinningTeam = CS_TEAM_CT
}

public target_saved() {
	g_ObjectiveWinner = 0
	g_BombPlanter = 0
	
	g_RewardWinner = (get_playersnum() >= 4)
	g_WinningTeam = CS_TEAM_CT
}

// cs_ map stuff
public hostages_not_rescued() {
	g_BombPlanter = -1
	g_RewardWinner = (get_playersnum() >= 4)
	g_WinningTeam = CS_TEAM_T
}

public all_hostages_rescued() {
	g_BombPlanter = -1
	g_RewardWinner = (get_playersnum() >= 4)
	g_WinningTeam = CS_TEAM_CT
}

public touched_hostage() {
	new userdata[48]
	read_logargv(0, userdata, 48)
	
	new id = GetLogUser(userdata)
	if (!id)
		return
		
	g_RescuingHostage[id]++
}

public hostage_rescued() {
	new userdata[48]
	read_logargv(0, userdata, 48)
	
	new id = GetLogUser(userdata)
	if (!id)
		return
		
	g_RescuingHostage[id]--
	g_Winners[g_WinnerCount] = 1
	g_WinnerCount++
}

public hook_postthink(id) {
	if (g_IsEnabled && gm_IsValidPlayer(id) && cs_get_user_team(id) == CS_TEAM_T) {
		if (pev(id, pev_button)&IN_USE) {
			get_user_aiming(id, pt_id, pt_body, 60)
			if (pt_id && g_IsHostage[pt_id]) {
				pt_hid = get_hostage_id(pt_id)
				if (cs_get_hostage_foll(pt_id) == 0 && pt_hid != -1) {
					pev(pt_id, pev_origin, pt_fVec)
					if (vec_distance(pt_fVec, g_HostageOrigin[pt_hid]) > 100) {
						engfunc(EngFunc_SetOrigin, pt_id, g_HostageOrigin[pt_hid])
						client_print(id, print_chat, "[GM] Teleported hostage back to spawn.")
						
						g_Winners[g_WinnerCount] = id
						g_WinnerCount++
					}
				}
			}
		}
	}
	
	return FMRES_IGNORED
}

public gm_UserJoined(id) {
	new xp = get_xp(id)
	if (xp > 0)
		gm_AddPoints(id, xp, 0)
}

get_hostage_id(ent) {
	for(new i=0;i<g_HostageCount;i++) {
		if (g_HostageEnt[i] == ent)
			return i
	}
	
	return -1
}

public get_xp(id) {
	if (is_user_bot(id)) return 0
	
	new steamid[32], key[64], value[32], tmp
	get_user_authid(id, steamid, 31)
	format(key, 63, "%s-extrapoints", steamid)
	if (nvault_lookup(gXPVault, key, value, 31, tmp)) {
		gXP[id] = str_to_num(value)
		return gXP[id]
	}
	
	gXP[id] = 0
	return 0
}

public alter_xp(id, diff) {
	if (is_user_bot(id)) return
	
	new steamid[32], key[64], value[32]
	get_user_authid(id, steamid, 31)
	format(key, 63, "%s-extrapoints", steamid)
	gXP[id] += diff
	if (gXP[id] < 0)
		gXP[id] = 0
	num_to_str(gXP[id], value, 31)
	nvault_set(gXPVault, key, value)
}

public gm_EnablingMod() {
	g_IsEnabled = 1
	task_hostage_god()
}

public gm_DisablingMod() {
	g_IsEnabled = 0
	for(new i=0;i<g_HostageCount;i++) {
		if (pev_valid(g_HostageEnt[i]))
			set_pev(g_HostageEnt[i], pev_health, 100.0)
	}
}
