//================================
// : UAIO (Ultimate All-In-One) Admin Menu
//  : 1.0.0
//  : MastaMan
// : lukuanenko.blogspot.com
//================================//
//
////////////////////////////////////////////////////////////////////////////////////////////
//   uaio_admin.sma                     1.51                       : /01/2006
//
//   RS UAIO ()    ()
//   : UAIO Admin -  
//
//   :    Rob Secord, B.Sc.
//   : xeroblood (aka; Achilles; sufferer)
//   . : xeroblood@msn.com
//
//   :    Dan Weeks
//   : $uicid3
//   . : suicid3m3@gmail.com
//
//    :  AMXX 1.50, 1.55, 1.60, 1.65, 1.70, 1.75 >
//   :    Fun
//                     Engine
//                     CStrike
//
//   :    CS 1.6 (STEAM)
//                     Linux HLDS
//                     Windows HLDS/ListenServer
//
//      : 81
//
////////////////////////////////////////////////////////////////////////////////////////////
//UAIO  : $uicid3
//     --  ; uaio_manager.sma   (  UAIO)
//
//     :			     RAD Clan, Mad Dog (v3x), $uicid3, Abhishek,GodLike
//
//       :                     Mad Dog (v3x), $uicid3, Abhishek, GodLike,
//				WillZ, FaDe, MattCook
//
//    :			jtp10181
//
//       :
//       -  		AssKicR, Lazy
//       -  ,   	AssKicR
//       - , 		f117bomb
//       -  		AssKicR, Scarzzurs
//       -  		Lazy
//       -                   	AssKicR
//       - 			Twilight Suzuka
//       -  		Mad Dog (v3x)
//       -  		VEN
//
//     :
//       - :		Proach
//       - :			[ --<-@ ] Black Rose
//       - :			MastaMan
//
//      :
//        AMX Mod X  !     <-- Visit: http://www.amxmodx.org
//          AMX Mod!    <-- Visit: http://www.amxmod.net
//
////////////////////////////////////////////////////////////////////////////////////////////
//    :
//
//     -  /20/2004 --  .      .
//     - /07/2005 --  .  - .1.0      .
//     - /20/2005 -- 90% . 3/4    (51     ).
//     - /24/2005 -- 95% .   1.  (69  ,  ).
//     - /06/2005 --  . /. ,   
//                    --   ,     
//     - /08/2005 --   2. (  73  ).
//                    --    /  ( : d3adlythegame)
//                    --    MOTD ( : Axyo)
//     - /15/2005 --   --     .
//                    --     (  ).
//     - /24/2005 --    1.1
//                    --   :  -    !
//     - /15/2005 --    1.2
//                    --     IP !
//                    --  : sv_uaio_show_activity ( amx_show_activity)
//                    --      HUD .
//                    --  : ./ ,  .
//                    --  6  :
//                          -  ,  ,  , ,
//                             ,  
//     - /29/2005 --    1.3
//                    --     ( jtp10181).
//                    --    AMXX 1.60
//     -  /08/2005 --    1.4
//                    --   .
//                    --     .
//     -  /18/2005 --    1.41
//                    --     !
//                          -  jtp10181,     !  :D
//     -  /20/2005 --        .
//                          -    $uicid3.
//     -  /20/2005 --    1.50
//                    --    
//                    --   
//                    --    /
//                    --    (  )
//                    --   'uaio_motd'
//                    --      uaio_manager.amxx
//                    --     VIP   
//     - /01/2006  --    1.51
//                    --     
//                    --   AMXX 1.75
//
//       :
//      http://forums.alliedmods.net/forumdisplay.php?f=95
//
////////////////////////////////////////////////////////////////////////////////////////////
//
//    
//     - G -                     (: boomy)
//     - G - ESP                           (: Mad Dog [v3x])
//     - M -    
//     - M -     
//     - M -                        (: $uicid3)
//
////////////////////////////////////////////////////////////////////////////////////////////


#include "uaio_inc/config.inc"          //  
                                        // (     )

#include <amxmodx>
#include <engine>
#include <cstrike>
#include <amxmisc>
#include <fun>

// UAIO Custom Includes
#include "uaio_inc/const.inc"           // Constant Defines
#include "uaio_inc/global.inc"          // Global Variables
#include "uaio_inc/stocks_common.inc"   // Common Stock Functions
#include "uaio_inc/stocks_player.inc"   // Player Stock Functions
#include "uaio_inc/stocks_exec.inc"     // Execution Stock Functions
#include "uaio_inc/files.inc"           // File Access Functions
#include "uaio_inc/commands.inc"        // Client Commands
#include "uaio_inc/actions_vote.inc"    // Vote Command Actions
#include "uaio_inc/actions_good.inc"    // Good Command Actions
#include "uaio_inc/actions_evil.inc"    // Evil Command Actions
#include "uaio_inc/actions_misc.inc"    // Misc Command Actions
#include "uaio_inc/menus.inc"           // Client Menu System
#include "uaio_inc/events.inc"          // Hooked Events
#include "uaio_inc/effects.inc"         // Command Special Effects

//    _______________
//___/ plugin_init() \______________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
public plugin_init()
{
    register_plugin( PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR )
    register_cvar( PLUGIN_NAME, PLUGIN_VERSION, FCVAR_SERVER )
    register_dictionary( "uaio_admin.txt" )

    //  -
    register_clcmd( "uaio_mode",   "ClCmd_UAIOMode",   UAIO_LVL_SUPER, "<on|off> - Toggles UAIO On/Off." )
    register_clcmd( "uaio_groups", "ClCmd_UAIOGroups", UAIO_LVL_SUPER, "- Displays All UAIO-Groups Information." )
    register_clcmd( "uaio_admins", "ClCmd_UAIOAdmins", UAIO_LVL_SUPER, "- Displays All UAIO-Admins Information." )

    //   
    register_clcmd( "uaio_group", "ClCmd_UAIOGroup", UAIO_LVL_ADMIN, "- Displays Your Group Information." )
    register_clcmd( "uaio_order", "ClCmd_UAIOOrder", UAIO_LVL_ADMIN, "- Toggles the Display Order of UAIO Menu." )
    
    //   
    register_clcmd( "uaio_menu",  "ClCmd_UAIOMenu",  UAIO_LVL_USER,  "- Displays UAIO-Admin Command Menu." )
    register_clcmd( "uaio_help",  "ClCmd_UAIOHelp",  UAIO_LVL_USER,  "- Displays UAIO-Admin Help Information" )

    // Say 
    register_clcmd( "say",      "ClCmd_CheckSay" )
    register_clcmd( "say_team", "ClCmd_CheckSay" )

    //   
    register_clcmd( "buyequip", "ClCmd_NoBuy" )
    register_clcmd( "buyammo1", "ClCmd_NoBuy" )
    register_clcmd( "buyammo2", "ClCmd_NoBuy" )

    register_clcmd( "uaio_debugarena" , "DebugArena")
    
    //  
    register_event( "DeathMsg",  "Event_DeathMsg",  "a" )
    register_event( "Money",     "Event_Money",     "b" )
    register_event( "ResetHUD",  "Event_ResetHUD",  "b" )
    register_event( "Damage",    "Event_Damage",    "b",  "2!0" )
    register_event( "CurWeapon", "Event_ChgWeapon", "be", "1=1" )
    register_event( "SendAudio", "Event_NadeThrow", "bc", "2=%!MRAD_FIREINHOLE" )
    register_event( "SetFOV",    "Event_SetFOV",    "be", "1<91" )
    register_event( "TextMsg",   "Event_TextMsg",   "be", "1=4", "2=#Weapon_Cannot_Be_Dropped")
    register_logevent( "Event_RoundStart", 2, "0=World triggered", "1=Round_Start" )
    register_logevent( "Event_RoundEnd",   2, "0=World triggered", "1=Round_End" )

    //  
    register_menucmd( register_menuid("\yPlayer Menu"),   1023, "Menu_UAIONext" )
    register_menucmd( register_menuid("\yCommand Menu"),  1023, "Menu_UAIONext" )
    register_menucmd( register_menuid("\yCommand Type"), 1023, "Menu_UAIOType" )
    register_menucmd( register_menuid("\ySettings Menu"), 1023, "Menu_UAIOAction" )

    //  
    register_menucmd( register_menuid("\y  "), 1023, "Menu_UAIOVoting" )

    //   
    register_menucmd( register_menuid("\yArena Menu"),              1023, "Menu_UAIOArenaWeapon" )
    register_menucmd( register_menuid("\yArena Pistols Menu"),      1023, "Menu_UAIOArenaReg" )
    register_menucmd( register_menuid("\yArena Shotguns Menu"),     1023, "Menu_UAIOArenaReg" )
    register_menucmd( register_menuid("\yArena SMGs Menu"),         1023, "Menu_UAIOArenaReg" )
    register_menucmd( register_menuid("\yArena Rifles Menu"),       1023, "Menu_UAIOArenaRifle" )
    register_menucmd( register_menuid("\yArena Machine Guns Menu"), 1023, "Menu_UAIOArenaReg" )
    register_menucmd( register_menuid("\yArena Equipment Menu"),    1023, "Menu_UAIOArenaReg" )
    register_menucmd( register_menuid("\yArena Sets Menu"),       1023, "Menu_UAIOArenaSets" )    

    //  
    register_menucmd( register_menuid("\yWeapons Menu"),      1023, "Menu_UAIOWeapon" )
    register_menucmd( register_menuid("\yPistols Menu"),      1023, "Menu_UAIOReg" )
    register_menucmd( register_menuid("\yShotguns Menu"),     1023, "Menu_UAIOReg" )
    register_menucmd( register_menuid("\ySMGs Menu"),         1023, "Menu_UAIOReg" )
    register_menucmd( register_menuid("\yRifles Menu"),       1023, "Menu_UAIORifle" )
    register_menucmd( register_menuid("\yMachine Guns Menu"), 1023, "Menu_UAIOReg" )
    register_menucmd( register_menuid("\yEquipment Menu"),    1023, "Menu_UAIOReg" )
    register_menucmd( register_menuid("\yExtras Menu"),       1023, "Menu_UAIOExtra" )
    
    //  
    register_cvar( "sv_uaio_show_activity",  "1" )  //   
                                                    // 0 - 
                                                   // 1 -    
                                                  // 2 -    

    register_cvar( "sv_uaio_immunity_vote",  "0" ) 	// 1=., 0=.
    register_cvar( "sv_uaio_immunity_evil",  "0" ) 		// 1=., 0=.
    register_cvar( "sv_uaio_immunity_good",  "0" ) 	// 1=., 0=.
    register_cvar( "sv_uaio_immunity_misc",  "0" ) 	// 1=., 0=.
    register_cvar( "sv_uaio_menu_start",     "0" ) 		// 0= , 1= 
    register_cvar( "sv_uaio_hud_color",      "103 248 007" )	//  HUD   
    
    // Vote-Specific Settings
    register_cvar( "sv_uaio_vote_time",      "10.0" )  	 //     
    register_cvar( "sv_uaio_vote_delay",     "11.0" ) 	 //       
    register_cvar( "sv_uaio_vote_ratio",     "0.40" )                 //      (1.0 =     , 0.0 =  )
    register_cvar( "sv_uaio_vote_answers",   "1" )  	 // 1= , 0= 
    
    // Command-Specific CVARs
    register_cvar( "sv_uaio_ban_ip",         "1" )          	 // 1=  IP, 0=  STEAM ID
    register_cvar( "sv_uaio_bslap_dmg",      "1" )         	 //       -
    register_cvar( "sv_uaio_fire_dmg",       "5" )		 //    / 
    register_cvar( "sv_uaio_poison_dmg",     "5" )            	 //   / .
    register_cvar( "sv_uaio_smoke_nades",    "1" )    	 // 1=  , 0= ...
    register_cvar( "sv_uaio_turbo_speed",    "750" )         	 //   ( 400 - 900)
    register_cvar( "sv_uaio_max_icash",      "16000" )      	 // .   (100-16000
    register_cvar( "sv_uaio_max_bcash",      "2000" )      	 // .  ($)   (50-5000)
    register_cvar( "sv_uaio_shades_alpha",   "120" )         	 //    
    register_cvar( "sv_uaio_blackout_color", "255 255 255" ) // RGB   " "

    //    ___________________________
    //___/    \____________________________________________
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //       [ 9 ]
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    new i , szUsage[STR_M]
    
    // 
    for( i = 0; i < MAX_V_COMMANDS; i++ )
    {
        format(szUsage , STR_M-1 , "%L" , LANG_SERVER , g_szVCmdUsage[i])
        register_clcmd( g_szVCmdConsole[i], "ClCmd_VoteCmd", UAIO_LVL_ADMIN, szUsage )
        if( g_szVCmdCvar[i][0] != '_' )
            register_cvar( g_szVCmdCvar[i], g_szVCmdCvarFlags[i] )
    }
    //  
    for( i = 0; i < MAX_G_COMMANDS; i++ )
    {
        format(szUsage , STR_M-1 , "%L" , LANG_SERVER , g_szGCmdUsage[i])
        register_clcmd( g_szGCmdConsole[i], "ClCmd_GoodCmd", UAIO_LVL_ADMIN, szUsage )
        if( g_szGCmdCvar[i][0] != '_' )
            register_cvar( g_szGCmdCvar[i], g_szGCmdCvarFlags[i] )
    }
    //  
    for( i = 0; i < MAX_E_COMMANDS; i++ )
    {
        format(szUsage , STR_M-1 , "%L" , LANG_SERVER , g_szECmdUsage[i])
        register_clcmd( g_szECmdConsole[i], "ClCmd_EvilCmd", UAIO_LVL_ADMIN, szUsage )
        if( g_szECmdCvar[i][0] != '_' )
            register_cvar( g_szECmdCvar[i], g_szECmdCvarFlags[i] )
    }
    //  
    for( i = 0; i < MAX_M_COMMANDS; i++ ) // Misc Commands/Cvars
    {
        format(szUsage , STR_M-1 , "%L" , LANG_SERVER , g_szMCmdUsage[i])
        register_clcmd( g_szMCmdConsole[i], "ClCmd_MiscCmd", UAIO_LVL_ADMIN, szUsage )
        if( g_szMCmdCvar[i][0] != '_' )
            register_cvar( g_szMCmdCvar[i], g_szMCmdCvarFlags[i] )
    }
    return
}

public DebugArena( id )
{
    console_print( id , "Arena enabled : %s^n# of Weapons : %d^n^nWepon #'s" , g_bArenaEnabled ? "yes" : "no" , g_iWepCount)
    for(new i = 0 ; i < AR_MAX_GUNS ; i++ )
        console_print( id , "%d. %d" , i+1 , g_iArenaCustom[i])
    return PLUGIN_HANDLED;
}
//    ______________
//___/ plugin_cfg() \_______________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
public plugin_cfg()
{
    new szLogMsg[STR_M]

    // Set Maximum Player Speed
    server_cmd( "sv_maxspeed 900" )

    // Client Message Indexes
    g_iMsgDamage = get_user_msgid( "Damage" )
    g_iMsgDeath  = get_user_msgid( "DeathMsg" )
    g_iMsgSetFOV = get_user_msgid( "SetFOV" )
    g_iMsgScreenFade = get_user_msgid( "ScreenFade" )
    g_iMsgScreenShake = get_user_msgid( "ScreenShake" )

    //   
    UAIO_NullAdmins()
    UAIO_BuildFileDir()
    g_bFileError[ERROR_MAPS]   = !UAIO_ReadMaps()
    g_bFileError[ERROR_CEXEC]  = !UAIO_ReadCExec()
    g_bFileError[ERROR_SEXEC]  = !UAIO_ReadSExec()
    g_bFileError[ERROR_AEXEC]  = !UAIO_ReadAExec()
    g_bFileError[ERROR_GROUPS] = !UAIO_ReadGroups()
    g_bFileError[ERROR_ADMINS] = !UAIO_ReadAdmins()

    //    -
    if( g_bFileError[ERROR_AEXEC] )
    {
        format( szLogMsg, STR_M-1, "%L", LANG_SERVER, "ERR_CFG_AEXEC", PLUGIN_MOD, PLUGIN_NAME )
        UAIO_WriteLog( szLogMsg )
    }

    //       
    if( g_bFileError[ERROR_GROUPS] )
    {
        format( szLogMsg, STR_M-1, "%L", LANG_SERVER, "ERR_CFG_GROUPS", PLUGIN_MOD, PLUGIN_NAME, g_szFileGroups )
        UAIO_WriteLog( szLogMsg )
        UAIO_PluginEnabled( 0 )
        return
    }
    if( g_bFileError[ERROR_ADMINS] )
    {
        format( szLogMsg, STR_M-1, "%L", LANG_SERVER, "ERR_CFG_ADMINS", PLUGIN_MOD, PLUGIN_NAME, g_szFileAdmins )
        UAIO_WriteLog( szLogMsg )
        UAIO_PluginEnabled( 0 )
        return
    }
    return
}
//    ___________________
//___/ plugin_precache() \__________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
public plugin_precache()
{
    g_sprBeam   = precache_model( "sprites/zbeam4.spr" )
    g_sprLaser  = precache_model( "sprites/laserbeam.spr" )
    g_sprWhite  = precache_model( "sprites/white.spr" )
    g_sprSmoke  = precache_model( "sprites/steam1.spr" )
    g_sprMFlash = precache_model( "sprites/muzzleflash.spr" )
    g_sprBFlare = precache_model( "sprites/blueflare2.spr" )
    
    precache_model( "models/scientist.mdl" )

    precache_sound( g_szSndFlames )
    precache_sound( g_szSndScream1 )
    precache_sound( g_szSndScream2 )
    precache_sound( g_szSndRocket1 )
    precache_sound( g_szSndRocket2 )
    precache_sound( g_szSndPoison )
    precache_sound( g_szSndBeep )
    precache_sound( g_szSndThunder )

    return
}
//    ______________________
//___/ client_authorized() \_______________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//public client_putinserver( id )
public client_authorized( id )
{
    if( !UAIO_PluginEnabled( UAIO_NULL ) )
        return

    // Flag User as Joining for ResetHUD
    g_bIsJoining[id-1] = true
    g_fAExecInterval[id-1] = 0.5

    // Check Groups
    if( !UAIO_AdminGroups( id ) )
    {
        new szLogMsg[STR_M], szUser[STR_T]
        get_user_name( id, szUser, STR_T-1 )
        format( szLogMsg, STR_M-1, "%L", LANG_SERVER, "ERR_NO_DEFAULT", PLUGIN_MOD, PLUGIN_NAME, szUser )
        UAIO_WriteLog( szLogMsg )
    }
    UAIO_RemoveAllFX( id )

    //    -
    UAIO_UserAExec( id, AUTOEXEC_INSTANT )

    return
}
//    _____________________
//___/ client_disconnect() \________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
public client_disconnect( id )
{
    if( !UAIO_PluginEnabled( UAIO_NULL ) )
        return

    // Call Auto-Exec Leave Commands
    UAIO_UserAExec( id, AUTOEXEC_LEAVE )
    g_fAExecInterval[id-1] = 0.5

    UAIO_ClearAdmin( id )
    UAIO_RemoveAllFX( id )
    return
}
//    ______________________
//___/ client_infochanged() \_______________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
public client_infochanged( id )
{
    if ( !UAIO_PluginEnabled( UAIO_NULL ) || !UAIO_HasEffect( id, CMDTYPE_EVIL, UAIO_E_NLOCK ) || !is_user_connected( id ) )
        return PLUGIN_CONTINUE

    new szNewName[STR_S]
    new szOldName[STR_S]

    get_user_info( id, "name", szNewName, STR_S-1 )
    get_user_name( id, szOldName, STR_S-1 )

    if( !equal( szNewName, szOldName ) )
        set_user_info( id, "name", szOldName )

    return PLUGIN_CONTINUE
}
//    ___________________
//___/ client_prethink() \__________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
public client_PreThink( id )
{
    if( !UAIO_PluginEnabled( UAIO_NULL ) )
        return PLUGIN_CONTINUE

    //  
    if( UAIO_HasEffect( id, CMDTYPE_GOOD, UAIO_G_SILENT ) )
        entity_set_int( id, EV_INT_flTimeStepSound, 999 )

    //  
    if( UAIO_HasEffect( id, CMDTYPE_GOOD, UAIO_G_DIVER ) )
        if( is_user_alive( id ) && entity_get_int( id, EV_INT_waterlevel ) == 3 )
            entity_set_float( id, EV_FL_air_finished, entity_get_float( id, EV_FL_air_finished ) + 1.0 )

    //  (  )
    if( UAIO_HasEffect( id, CMDTYPE_EVIL, UAIO_E_FIRE ) )
    {
        if( is_user_alive( id ) && entity_get_int( id, EV_INT_waterlevel ) == 3 )
        {
            client_print( id, print_chat, "%L", LANG_PLAYER, "WATER_FLAMES", PLUGIN_MOD, PLUGIN_NAME )
            UAIO_RemoveEffect( id, CMDTYPE_EVIL, UAIO_E_FIRE )
        }
    }

    return PLUGIN_CONTINUE
}
//    __________________
//___/ client_command() \___________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
public client_command( id )
{
    if( UAIO_HasEffect( id, CMDTYPE_EVIL, UAIO_E_NOBUY ) )
    {
        /*      11 ,     . (AssKicR) */ 
        new szArg[13]
        if( read_argv( 0, szArg, 12 ) > 11 )
            return PLUGIN_CONTINUE 
    
        new i
        for( i = 0; i < MAX_ALIASES; i++ )
            if( equal( g_szWeaponAlias[i], szArg ) )
                return PLUGIN_HANDLED 
    }
    return PLUGIN_CONTINUE
}
