/*  AMXModX Script
*
*   Title:    Anti-Silent Plant (antisilentplant)
*   Author:   SubStream
*
*   Current Version:   1.5
*   Release Date:      2006-05-23
*
*   For support on this plugin, please visit the following URL:
*   Anti-Silent Plant URL = http://forums.alliedmods.net/showthread.php?t=28133
*
*   Anti-Silent Plant - Prevents a silent plant from occuring.
*   Copyright (C) 2006  SubStream
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either version 2
*   of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*   Author Contact Email: starlineclan@dj-rj.com
*/


#include <amxmodx>
#include <amxmisc>
#include <fakemeta>


new const gs_PLUGIN[]	= "Anti-Silent Plant"
new const gs_VERSION[]	= "1.5"
new const gs_AUTHOR[]	= "SubStream"


new const gs_C4_MODEL[]	= "models/w_c4.mdl"


#define gi_SOUND_MAX	5
#define gi_SOUND_MIN	0


new bool: gb_CheckSound
new bool: gb_EntReadyForUse
new bool: gb_OriginChanged


new Float: gf_volume
new Float: gf_attenuation
new Float: gfv_c4origin[3]
new Float: gfv_entorigin[3]


new gi_flags
new gi_pitch


new g_c4entity
new g_entillusionary
new g_classname


new gi_soundnum

new gs_sound[gi_SOUND_MAX][] =
{
	"weapons/c4_beep1.wav",
	"weapons/c4_beep2.wav",
	"weapons/c4_beep3.wav",
	"weapons/c4_beep4.wav",
	"weapons/c4_beep5.wav"
}


public plugin_init ()
{
	register_plugin ( gs_PLUGIN, gs_VERSION, gs_AUTHOR )
	register_cvar ( "antisilentplant_version", gs_VERSION, FCVAR_SERVER|FCVAR_SPONLY )
	
	if ( engfunc ( EngFunc_FindEntityByString, -1, "classname", "func_bomb_target" ) )
	{
		register_logevent ( "fn_triggerplanted" , 3, "1=triggered", "2=Planted_The_Bomb" )
		register_logevent ( "fn_triggerroundstart" , 2, "1=Round_Start" )
		register_forward ( FM_EmitSound, "fn_soundcheck" )
	}
	
	gb_EntReadyForUse = false
}

public fn_triggerplanted ()
{
	gb_CheckSound = true
}

public fn_triggerroundstart ()
{
	gb_CheckSound = false
	gb_OriginChanged = false
}

public fn_soundcheck ( entity, i_channel, const s_SOUND[], Float: f_volume, Float: f_attenuation, i_flags, i_pitch )
{
	if ( gb_CheckSound == true )
	{
		for ( gi_soundnum = gi_SOUND_MIN; gi_soundnum < gi_SOUND_MAX; gi_soundnum++ )
		{
			if ( equali ( s_SOUND, gs_sound[gi_soundnum] ) )
			{
				gf_volume = f_volume
				gf_attenuation = f_attenuation
				gi_flags = i_flags
				gi_pitch = i_pitch
				
				if ( gb_EntReadyForUse == true && gb_OriginChanged == true )
				{
					fn_emitsound ()
					return FMRES_SUPERCEDE
				}
				
				else if ( gb_EntReadyForUse == true && ! gb_OriginChanged == true )
				{
					fn_changeorigin ()
					return FMRES_SUPERCEDE
				}
				
				else
				{
					fn_createentity ()
					return FMRES_SUPERCEDE
				}
			}
		}
	}
	
	return FMRES_IGNORED
}

public fn_createentity ()
{
	g_classname = engfunc ( EngFunc_AllocString, "func_illusionary" )
	g_entillusionary = engfunc ( EngFunc_CreateNamedEntity, g_classname )
	
	gb_EntReadyForUse = true
	
	fn_changeorigin ()
}

public fn_changeorigin ()
{
	g_c4entity = engfunc ( EngFunc_FindEntityByString, -1, "model", gs_C4_MODEL )
	pev ( g_c4entity, pev_origin, gfv_c4origin )
	gfv_entorigin = gfv_c4origin
	engfunc ( EngFunc_SetOrigin, g_entillusionary, gfv_entorigin )
	
	gb_OriginChanged = true
	
	fn_emitsound ()
}

public fn_emitsound ()
{
	emit_sound ( g_entillusionary, CHAN_AUTO, gs_sound[gi_soundnum], gf_volume, gf_attenuation, gi_flags, gi_pitch )
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
