/*
*     Vote Kick/Ban Menu
*        by WaZZeR
*
*   An easy vote menu for kick and ban
*   
*   The defult acces flag is 'j' - ADMIN_VOTE
*
*   You can add this to you custommenuitems.cfg to add the menu
*   to the main menu:
*
*   amx_addmenuitem "Vote Menu" "amx_votemenu" "j" "Vote Menu"
*
*
*   Thanks to:
*     v3x       - helped me with the loose indentation error 
*     xeroblood - for the palyer menu template
*
*
*   Log:
*     1.3
*       *Make it into one menu
*     1.2
*       *Fixed so you can vote on dead payers to :)
*     1.1
*       *Fixed the problem in 1.0, run good now
*     1.0
*       *Diden't worked to well, the menu text wasn't right.
*
*
*   Todo:
*       *Add possibility to change ban time
*       *Added amx_ban support
*
*/
#include <amxmodx>
#include <amxmisc>

#define MENU_SIZE    256
#define MENU_PLAYERS 7

new g_iMenuPosition
new g_iMenuPlayers[32]
new g_iMenuOption[32]
new g_iMenuSettings[32]


public plugin_init()
{
    register_plugin("Vote Kick/Ban Menu","1.3","WaZZeR")

    register_menucmd(register_menuid("\rVote Menu:"),1023,"actionVoteMenu")

    register_clcmd("amx_votemenu","cmdVoteMenu",ADMIN_VOTE,"- displays vote menu")
}


/* Vote Menu */
public cmdVoteMenu( id, lvl, cid )
{
    if( cmd_access( id, lvl, cid, 0 ) )
    {
        g_iMenuOption[id] = 0
        g_iMenuSettings[id] = 0

        showVoteMenu( id, g_iMenuPosition = 0 )
    }
    return PLUGIN_HANDLED
}

public showVoteMenu( id, pos )
{
    if( pos < 0 ) return

    new i, j
    new szMenuBody[MENU_SIZE]
    new iCurrKey = 0
    new szUserName[32]
    new iStart = pos * MENU_PLAYERS
    new iNum

    get_players( g_iMenuPlayers, iNum )

    if( iStart >= iNum )
        iStart = pos = g_iMenuPosition = 0

    new iLen = format( szMenuBody, MENU_SIZE-1, "\rVote Menu:\R%d/%d^n\w^n", pos+1, (iNum / MENU_PLAYERS + ((iNum % MENU_PLAYERS) ? 1 : 0 )) )
    new iEnd = iStart + MENU_PLAYERS
    new iKeys = (1<<9|1<<7)

    if( iEnd > iNum )
        iEnd = iNum

    for( i = iStart; i < iEnd; i++ )
    {
        j = g_iMenuPlayers[i]
        get_user_name( j, szUserName, 31 )
		
        //Check if the player has immunity
        if( (get_user_flags(j) & ADMIN_IMMUNITY) )
        {
            iCurrKey++
            iLen += format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "\d%d. %s^n\w", iCurrKey, szUserName )
        }else
        {
            iKeys |= (1<<iCurrKey++)
            iLen += format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "%d. %s^n", iCurrKey, szUserName )
        }
    }
    //Check if it is kick or ban
    if ( g_iMenuSettings[id] )
        iLen += format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "^n8. Vote Ban^n" )
    else
        iLen += format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "^n8. Vote Kick^n" )

    //Cheack if there is more players left
    if( iEnd != iNum )
    {
        format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "^n9. More...^n0. %s", pos ? "Back" : "Exit" )
        iKeys |= (1<<8)
    }
    else
        format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "^n0. %s", pos ? "Back" : "Exit" )

    show_menu( id, iKeys, szMenuBody, -1 )

    return
}

public actionVoteMenu( id, key )
{
    switch( key )
    {
        case 7: {   //The switch key
            ++g_iMenuOption[id]
            g_iMenuOption[id] %= 2

            switch(g_iMenuOption[id]){
            case 0: g_iMenuSettings[id] = 0    //kick
            case 1: g_iMenuSettings[id] = 1    //ban
            }     
            showVoteMenu( id, g_iMenuPosition )
        }
        case 8: showVoteMenu( id, ++g_iMenuPosition ) // More Option
        case 9: showVoteMenu( id, --g_iMenuPosition ) // Back Option

        // Chose a Player
        default:
        {
            new player = g_iMenuPlayers[g_iMenuPosition * MENU_PLAYERS + key]

            //Get user info

            new authid[32]
            get_user_authid(player,authid,31)

            new userid = get_user_userid(player)

            //Exec the command

            if (equal("4294967295",authid)) { /* check if it is a lan */
                new ipa[32]
                get_user_ip(player,ipa,31,1)
                server_cmd("addip 0.0 %s;writeip",ipa) /* no need to vote on lan, or? */
            }
            else {
                switch(g_iMenuSettings[id]){
                    case 0: server_cmd("amx_votekick #%d",userid)
                    case 1: server_cmd("amx_voteban #%d kick;writeid",userid)
                }
            }			
            server_exec()
        }
    }
    return PLUGIN_HANDLED
}
