/*
* Simple Clanwar Management 1.1
* by rhin0
*
* http://www.CounterServer.cz
*
*  Simple AMXModX plugin for managing clanwars.
*  Currently, there are these commands available:
*
*   say /start - 3x restart and start the match
*   say /stop - stop the match
*   say /rr - restart round
*   say /knife - play knife round
*   say /scmhelp - display help in MOTD window
*   say /<mapname minus de_ prefix> (ie. say /dust2, say /cpl_mill, etc.) - change map
*
*  Changelog:
*   1.1 (17.2.2008)
*     - fixed loading maps from maplist.ini file
*     - dictionary is now loaded as expected
*   1.0 (8.1.2007)
*     - available map commands are now loaded from maplist.ini file
*     - added multilingual support
*     - new command say /knife to play knife round (thanks to Dupl3xx)
*     - help is now displayed in MOTD window
*     - cw.cfg resp. warmup.cfg is executed on startup resp. in the end, of the match (thanks to Dupl3xx)
*   0.8 (5.4.2006)
*     - SCM plugin is no longer compatible with AMXMod
*     - SCM commands now available only to admins with access to menu (flag u) - can be changed
*     - help message when player connects cannot be disabled anymore
*   0.7 (3.4.2006) - last version vith AMXMod support
*     - help message now displayed only once when player connects - can be disabled completely
*     - new command say /scmhelp to display help
*     - few small tweaks
*   0.6 (22.2.2006)
*     - disabled changing map when match is started
*     - improved command say /stop
*   0.5 (21.2.2006) - never released to public
*     - commands to switch to six most played maps (de_cbble, de_cpl_mill, de_dust2, de_inferno, de_nuke, de_train)
*     - new commands are:
*       - say /cbble
*       - say /cpl_mill
*       - say /dust2
*       - say /inferno
*       - say /nuke
*       - say /train
*   0.2 (20.2.2006)
*     - option to switch between AMXModX and AMXMod (see lines below)
*   0.1 (16.2.2006)
*     - initial release
*
*/

//#define ADMINS_ONLY // comment this line to allow SCM commands for all players

#define MAX_MAPS 128 // max number of maps in map list (if you need more maps, just change this value to suits your needs)

#define SCM_DICT "scm.txt"
#define SCM_MAPS "maplist.ini"
#define SCM_CW "cw.cfg"
#define SCM_WARM "warmup.cfg"

// DO NOT EDIT BELOW
#include <amxmodx>
#include <amxmisc>
#include <fun>

#define PLUGIN "Simple Clanwar Management"
#define VERSION "1.1"
#define AUTHOR "rhin0"

new g_match_inprogress = 0

new g_mapnames[MAX_MAPS][32]
new g_mapcount

new g_filename[256]

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd("say", "check_map", 0, "- [SCM] check if the user say map change command")
	
	register_clcmd("say /start", "cmd_start", 0, "- [SCM] 3x restart and start the match")
	register_clcmd("say /stop", "cmd_stop", 0, "- [SCM] stop the match")
	register_clcmd("say /rr", "cmd_rr", 0, "- [SCM] restart round")
	register_clcmd("say /knife", "cmd_knives", 0, "- [SCM] kniferound")
	register_clcmd("say /scmhelp", "cmd_showhelp", 0, "- [SCM] show help (MOTD)")
	
	register_dictionary(SCM_DICT)
	
	read_maps()
}

#if defined ADMINS_ONLY
public client_putinserver(id) {
	if (access(id, ADMIN_MENU)) {
		if (is_user_bot(id)) return
		set_task(10.0, "showhelp", id)
	} else return
}

public client_disconnect(id) {
	remove_task(id)
}
#else
public client_putinserver(id) {
	if (is_user_bot(id))
		return
	set_task(10.0, "showhelp", id)
}

public client_disconnect(id) {
	remove_task(id)
}
#endif

public read_maps() {
	new textlength
	
	get_filename(SCM_MAPS)
	
	new line = 0
	while (line < MAX_MAPS && read_file(g_filename, line, g_mapnames[line], 30, textlength)) {
		++line
	}
	log_message("SCM: loaded %i maps", line)
	g_mapcount = line
}

public check_map(id) {
	new said[192]
	read_args(said, 191)
	
	new i = 0
	while (i < g_mapcount) {
		new trash[16], mapname[32]
		strtok(g_mapnames[i], trash, 15, mapname, 31, '_')
		format(mapname, 31, "^"/%s^"", mapname)
		if (equali(said, mapname)) {
			cmd_changemap(id, g_mapnames[i])
		}
		++i
	}
}

public cmd_changemap(id, mapname[]) {
#if defined ADMINS_ONLY
	if (!access(id, ADMIN_MENU)) {
		client_print(id, print_chat, "[SCM] !!! %L", id, "NO_ACCESS")
		return PLUGIN_HANDLED
	}
#endif
	if (g_match_inprogress != 1) {
		set_task(2.0, "change_map", 0, mapname, strlen(mapname))
		
		new message[64]
		format(message, 63, "%L", id, "CHANGELEVEL", mapname)
		all_msg(message)
	} else {
		client_print(id, print_chat, "[SCM] !!! %L", id, "CANNOT_CHANGE_MAP")
	}

	return PLUGIN_CONTINUE
}

public cmd_knives(id) { 
#if defined ADMINS_ONLY
	if (!access(id, ADMIN_MENU)) {
		client_print(id, print_chat, "[SCM] !!! %L", id, "NO_ACCESS")
		return PLUGIN_HANDLED
	}
#endif
	if (g_match_inprogress != 1) {
		g_match_inprogress = 0
		
		set_task(1.0, "restart_round", 0, "1", 1)
		all_msg("knife round")
		set_task(3.0, "strip_weapons")
		set_task(4.0, "knife_msg")
	} else {
		client_print(id, print_chat, "[SCM] !!! %L", id, "CANNOT_STOP_MATCH")
	}

	return PLUGIN_CONTINUE
}

public cmd_start(id) {
#if defined ADMINS_ONLY
	if (!access(id, ADMIN_MENU)) {
		client_print(id, print_chat, "[SCM] !!! %L", id, "NO_ACCESS")
		return PLUGIN_HANDLED
	}
#endif
	if (g_match_inprogress != 1) {
		set_task(1.0, "restart_round", 0, "1", 1)
		all_msg("starting match")
		g_match_inprogress = 1
		
		get_filename(SCM_CW)
		server_cmd("exec %s", g_filename)
		client_print(0, print_chat, "[SCM] !!! %L", LANG_PLAYER, "CWTG_CFG_LOADED")
		
		set_task(3.0, "restart_round", 0, "1", 1)
		set_task(5.0, "restart_round", 0, "3", 1)
		set_task(9.0, "live_msg")
	} else {
		client_print(id, print_chat, "[SCM] !!! %L", id, "CANNOT_START_MATCH")
	}
	
	return PLUGIN_CONTINUE
}

public cmd_stop(id) {
#if defined ADMINS_ONLY
	if (!access(id, ADMIN_MENU)) {
		client_print(id, print_chat, "[SCM] !!! %L", id, "NO_ACCESS")
		return PLUGIN_HANDLED
	}
#endif
	if (g_match_inprogress == 1) {
		all_msg("stopping match")
		g_match_inprogress = 0
		
		get_filename(SCM_WARM)
		server_cmd("exec %s", g_filename)
		client_print(0, print_chat, "[SCM] !!! %L", LANG_PLAYER, "WRM_CFG_LOADED")
		
		set_task(3.0, "restart_round", 0, "1", 1)
		set_task(6.0, "all_msg", 0, "match stopped", 13)
	} else {
		client_print(id, print_chat, "[SCM] !!! %L", id, "CANNOT_STOP_MATCH")
	}
	
	return PLUGIN_CONTINUE
}

public cmd_rr(id) {
#if defined ADMINS_ONLY
	if (!access(id, ADMIN_MENU)) {
		client_print(id, print_chat, "[SCM] !!! %L", id, "NO_ACCESS")
		return PLUGIN_HANDLED
	}
#endif
	if (g_match_inprogress != 1) {
		set_task(1.0, "restart_round", 0, "1", 1)
		all_msg("restart")
	} else {
		client_print(id, print_chat, "[SCM] !!! %L", id, "CANNOT_RESTART_MATCH")
	}
	
	return PLUGIN_CONTINUE
}

public strip_weapons() {
	new plist_public[32], pnum_public
	get_players(plist_public, pnum_public)
	for (new i = 0; i < pnum_public; i++) {
		if (is_user_connected(plist_public[i]) == 1 && is_user_alive(plist_public[i]) == 1){
			strip_user_weapons(plist_public[i])
			give_item(plist_public[i], "weapon_knife")
		}
	}
}

public get_filename(filename[]) {

	new dir[128]
	
	get_configsdir(dir, 127)
	format(g_filename, 255, "%s/scm/%s", dir, filename)
	
	if (!file_exists(g_filename)) {
		log_message("SCM: file %s not found", filename)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}

public change_map(map[]) {
	server_cmd("changelevel %s", map)

	return PLUGIN_CONTINUE
}

public restart_round(seconds[]) {
	server_cmd("sv_restartround %s", seconds)

	return PLUGIN_CONTINUE
}

public live_msg() {
	set_hudmessage(255, 0, 0, -1.0, 0.2, 0, 6.0, 6.0)
	show_hudmessage(0, "--- live - live - live ---^n--- live - live - live ---^n--- live - live - live ---")
	client_print(0, print_chat, "*** live - live - live ***")
	client_print(0, print_chat, "*** live - live - live ***")
	client_print(0, print_chat, "*** live - live - live ***")

	return PLUGIN_CONTINUE
}

public knife_msg() { 
	set_hudmessage(255, 0, 0, -1.0, 0.2, 0, 6.0, 6.0) 
	show_hudmessage(0, "--- knife round - knife round - knife round ---^n--- knife round - knife round - knife round ---^n--- knife round - knife round - knife round ---") 
	client_print(0, print_chat, "*** knife round - knife round - knife round ***") 
	client_print(0, print_chat, "*** knife round - knife round - knife round ***") 
	client_print(0, print_chat, "*** knife round - knife round - knife round ***") 
	return PLUGIN_CONTINUE 
}

public all_msg(msg[]) {
	set_hudmessage(255, 0, 0, -1.0, 0.2, 0, 6.0, 6.0)
	show_hudmessage(0, "--- %s ---", msg)
	client_print(0, print_chat, "*** %s ***", msg)

	return PLUGIN_CONTINUE
}

public showhelp(id) {
#if defined ADMINS_ONLY
	if (!access(id, ADMIN_MENU)) {
		client_print(id, print_chat, "[SCM] !!! %L", id, "NO_ACCESS")
		return PLUGIN_HANDLED
	}
#endif
	client_print(id, print_chat, "[SCM] %L", id, "HELP_START_STOP")
	client_print(id, print_chat, "[SCM] %L", id, "HELP_RR")
	client_print(id, print_chat, "[SCM] %L", id, "HELP_MOTD")
	
	return PLUGIN_CONTINUE
}

public cmd_showhelp(id) {
	new motd[2048], line[256], title[64]
	
	add(motd, 2047, "<html><head><style>")
	add(motd, 2047, "body {font-family: Tahoma; font-size: 12px}")
	add(motd, 2047, "code {font-size: 14px; margin: 0 10px 0 0}")
	add(motd, 2047, "h1 {font-size: 18px; text-align: center}")
	add(motd, 2047, "h2 {font-size: 14px; font-weight: bold}")
	add(motd, 2047, "p {text-align: center; margin: 5px}")
	add(motd, 2047, "a {color: #991A00}")
	add(motd, 2047, "</style></head><body>")
	add(motd, 2047, "<div>")
	format(line, 255, "<h1>%s %s (SCM)</h1>", PLUGIN, VERSION)
	add(motd, 2047, line)
	format(line, 255, "<p>%L <strong>rhin0</strong></p>", id, "MOTD_CREDITS")
	add(motd, 2047, line)
	format(line, 255, "<p>%L <a href=http://www.counterserver.cz>www.CounterServer.cz</a></p>", id, "MOTD_INFO")
	add(motd, 2047, line)
	format(line, 255, "<h2>%L</h2>", id, "MOTD_GEN_CMD")
	add(motd, 2047, line)
	format(line, 255, "<ul><li><code>say /start</code> // %L</li>", id, "MOTD_START_MATCH")
	add(motd, 2047, line)
	format(line, 255, "<li><code>say /stop</code> // %L</li>", id, "MOTD_STOP_MATCH")
	add(motd, 2047, line)
	format(line, 255, "<li><code>say /rr</code> // %L</li>", id, "MOTD_RESTART_MATCH")
	add(motd, 2047, line)
	format(line, 255, "<li><code>say /scmhelp</code> // %L</li></ul>", id, "MOTD_SHOW_HELP")
	add(motd, 2047, line)
	format(line, 255, "<h2>%L</h2>", id, "MOTD_MAPS_CMD")
	add(motd, 2047, line)
	add(motd, 2047, "<ul>")
	
	new i = 0
	while (i < g_mapcount) {
		new mapcmd[128], trash[16], mapname[32]
		strtok(g_mapnames[i], trash, 15, mapname, 31, '_')
		format(mapcmd, 127, "<li><code>say /%s</code> // %L %s</li>", mapname, id, "MOTD_CHANGELEVEL", g_mapnames[i])
		add(motd, 2047, mapcmd)
		++i
	}
	
	add(motd, 2047, "</ul>")
	add(motd, 2047, "</div></body></html>")
	format(title, 63, "%s %s", PLUGIN, VERSION)
	show_motd(id, motd, title)
	
	return PLUGIN_HANDLED
}
